// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Enum to indicate default priorityLevel of requests. </summary>
    public readonly partial struct DefaultPriorityLevel : IEquatable<DefaultPriorityLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DefaultPriorityLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DefaultPriorityLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HighValue = "High";
        private const string LowValue = "Low";

        /// <summary> High. </summary>
        public static DefaultPriorityLevel High { get; } = new DefaultPriorityLevel(HighValue);
        /// <summary> Low. </summary>
        public static DefaultPriorityLevel Low { get; } = new DefaultPriorityLevel(LowValue);
        /// <summary> Determines if two <see cref="DefaultPriorityLevel"/> values are the same. </summary>
        public static bool operator ==(DefaultPriorityLevel left, DefaultPriorityLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DefaultPriorityLevel"/> values are not the same. </summary>
        public static bool operator !=(DefaultPriorityLevel left, DefaultPriorityLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DefaultPriorityLevel"/>. </summary>
        public static implicit operator DefaultPriorityLevel(string value) => new DefaultPriorityLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DefaultPriorityLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DefaultPriorityLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
