// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> DedicatedGatewayType for the service. </summary>
    public readonly partial struct DedicatedGatewayType : IEquatable<DedicatedGatewayType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DedicatedGatewayType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DedicatedGatewayType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IntegratedCacheValue = "IntegratedCache";
        private const string DistributedQueryValue = "DistributedQuery";

        /// <summary> IntegratedCache. </summary>
        public static DedicatedGatewayType IntegratedCache { get; } = new DedicatedGatewayType(IntegratedCacheValue);
        /// <summary> DistributedQuery. </summary>
        public static DedicatedGatewayType DistributedQuery { get; } = new DedicatedGatewayType(DistributedQueryValue);
        /// <summary> Determines if two <see cref="DedicatedGatewayType"/> values are the same. </summary>
        public static bool operator ==(DedicatedGatewayType left, DedicatedGatewayType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DedicatedGatewayType"/> values are not the same. </summary>
        public static bool operator !=(DedicatedGatewayType left, DedicatedGatewayType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DedicatedGatewayType"/>. </summary>
        public static implicit operator DedicatedGatewayType(string value) => new DedicatedGatewayType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DedicatedGatewayType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DedicatedGatewayType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
