// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The metadata related to each access key for the given Cosmos DB database account. </summary>
    public partial class DatabaseAccountKeysMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DatabaseAccountKeysMetadata"/>. </summary>
        internal DatabaseAccountKeysMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DatabaseAccountKeysMetadata"/>. </summary>
        /// <param name="primaryMasterKey"> The metadata related to the Primary Read-Write Key for the given Cosmos DB database account. </param>
        /// <param name="secondaryMasterKey"> The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account. </param>
        /// <param name="primaryReadonlyMasterKey"> The metadata related to the Primary Read-Only Key for the given Cosmos DB database account. </param>
        /// <param name="secondaryReadonlyMasterKey"> The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DatabaseAccountKeysMetadata(AccountKeyMetadata primaryMasterKey, AccountKeyMetadata secondaryMasterKey, AccountKeyMetadata primaryReadonlyMasterKey, AccountKeyMetadata secondaryReadonlyMasterKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrimaryMasterKey = primaryMasterKey;
            SecondaryMasterKey = secondaryMasterKey;
            PrimaryReadonlyMasterKey = primaryReadonlyMasterKey;
            SecondaryReadonlyMasterKey = secondaryReadonlyMasterKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The metadata related to the Primary Read-Write Key for the given Cosmos DB database account. </summary>
        internal AccountKeyMetadata PrimaryMasterKey { get; }
        /// <summary> Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18. </summary>
        [WirePath("primaryMasterKey.generationTime")]
        public DateTimeOffset? PrimaryMasterKeyGeneratedOn
        {
            get => PrimaryMasterKey?.GeneratedOn;
        }

        /// <summary> The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account. </summary>
        internal AccountKeyMetadata SecondaryMasterKey { get; }
        /// <summary> Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18. </summary>
        [WirePath("secondaryMasterKey.generationTime")]
        public DateTimeOffset? SecondaryMasterKeyGeneratedOn
        {
            get => SecondaryMasterKey?.GeneratedOn;
        }

        /// <summary> The metadata related to the Primary Read-Only Key for the given Cosmos DB database account. </summary>
        internal AccountKeyMetadata PrimaryReadonlyMasterKey { get; }
        /// <summary> Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18. </summary>
        [WirePath("primaryReadonlyMasterKey.generationTime")]
        public DateTimeOffset? PrimaryReadonlyMasterKeyGeneratedOn
        {
            get => PrimaryReadonlyMasterKey?.GeneratedOn;
        }

        /// <summary> The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account. </summary>
        internal AccountKeyMetadata SecondaryReadonlyMasterKey { get; }
        /// <summary> Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that the last key regeneration was triggered before 2022-06-18. </summary>
        [WirePath("secondaryReadonlyMasterKey.generationTime")]
        public DateTimeOffset? SecondaryReadonlyMasterKeyGeneratedOn
        {
            get => SecondaryReadonlyMasterKey?.GeneratedOn;
        }
    }
}
