// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Properties for Create or Update request for DataTransferServiceResource. </summary>
    public partial class DataTransferServiceResourceCreateUpdateProperties : ServiceResourceCreateUpdateProperties
    {
        /// <summary> Initializes a new instance of <see cref="DataTransferServiceResourceCreateUpdateProperties"/>. </summary>
        public DataTransferServiceResourceCreateUpdateProperties()
        {
            ServiceType = CosmosDBServiceType.DataTransfer;
        }

        /// <summary> Initializes a new instance of <see cref="DataTransferServiceResourceCreateUpdateProperties"/>. </summary>
        /// <param name="instanceSize"> Instance type for the service. </param>
        /// <param name="instanceCount"> Instance count for the service. </param>
        /// <param name="serviceType"> ServiceType for the service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataTransferServiceResourceCreateUpdateProperties(CosmosDBServiceSize? instanceSize, int? instanceCount, CosmosDBServiceType serviceType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(instanceSize, instanceCount, serviceType, serializedAdditionalRawData)
        {
            ServiceType = serviceType;
        }
    }
}
