// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Mode of job execution. </summary>
    public readonly partial struct DataTransferJobMode : IEquatable<DataTransferJobMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataTransferJobMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataTransferJobMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OfflineValue = "Offline";
        private const string OnlineValue = "Online";

        /// <summary> Offline. </summary>
        public static DataTransferJobMode Offline { get; } = new DataTransferJobMode(OfflineValue);
        /// <summary> Online. </summary>
        public static DataTransferJobMode Online { get; } = new DataTransferJobMode(OnlineValue);
        /// <summary> Determines if two <see cref="DataTransferJobMode"/> values are the same. </summary>
        public static bool operator ==(DataTransferJobMode left, DataTransferJobMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataTransferJobMode"/> values are not the same. </summary>
        public static bool operator !=(DataTransferJobMode left, DataTransferJobMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataTransferJobMode"/>. </summary>
        public static implicit operator DataTransferJobMode(string value) => new DataTransferJobMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataTransferJobMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataTransferJobMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
