// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The DataTransferComponent. </summary>
    internal readonly partial struct DataTransferComponent : IEquatable<DataTransferComponent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataTransferComponent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataTransferComponent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CosmosDBCassandraValue = "CosmosDBCassandra";
        private const string CosmosDBMongoValue = "CosmosDBMongo";
        private const string CosmosDBMongoVCoreValue = "CosmosDBMongoVCore";
        private const string CosmosDBSqlValue = "CosmosDBSql";
        private const string AzureBlobStorageValue = "AzureBlobStorage";

        /// <summary> CosmosDBCassandra. </summary>
        public static DataTransferComponent CosmosDBCassandra { get; } = new DataTransferComponent(CosmosDBCassandraValue);
        /// <summary> CosmosDBMongo. </summary>
        public static DataTransferComponent CosmosDBMongo { get; } = new DataTransferComponent(CosmosDBMongoValue);
        /// <summary> CosmosDBMongoVCore. </summary>
        public static DataTransferComponent CosmosDBMongoVCore { get; } = new DataTransferComponent(CosmosDBMongoVCoreValue);
        /// <summary> CosmosDBSql. </summary>
        public static DataTransferComponent CosmosDBSql { get; } = new DataTransferComponent(CosmosDBSqlValue);
        /// <summary> AzureBlobStorage. </summary>
        public static DataTransferComponent AzureBlobStorage { get; } = new DataTransferComponent(AzureBlobStorageValue);
        /// <summary> Determines if two <see cref="DataTransferComponent"/> values are the same. </summary>
        public static bool operator ==(DataTransferComponent left, DataTransferComponent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataTransferComponent"/> values are not the same. </summary>
        public static bool operator !=(DataTransferComponent left, DataTransferComponent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataTransferComponent"/>. </summary>
        public static implicit operator DataTransferComponent(string value) => new DataTransferComponent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataTransferComponent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataTransferComponent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
