// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> A CosmosDB No Sql API data source/sink. </summary>
    public partial class CosmosSqlDataTransferDataSourceSink : BaseCosmosDataTransferDataSourceSink
    {
        /// <summary> Initializes a new instance of <see cref="CosmosSqlDataTransferDataSourceSink"/>. </summary>
        /// <param name="databaseName"></param>
        /// <param name="containerName"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="databaseName"/> or <paramref name="containerName"/> is null. </exception>
        public CosmosSqlDataTransferDataSourceSink(string databaseName, string containerName)
        {
            Argument.AssertNotNull(databaseName, nameof(databaseName));
            Argument.AssertNotNull(containerName, nameof(containerName));

            DatabaseName = databaseName;
            ContainerName = containerName;
            Component = DataTransferComponent.CosmosDBSql;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosSqlDataTransferDataSourceSink"/>. </summary>
        /// <param name="component"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="remoteAccountName"></param>
        /// <param name="databaseName"></param>
        /// <param name="containerName"></param>
        internal CosmosSqlDataTransferDataSourceSink(DataTransferComponent component, IDictionary<string, BinaryData> serializedAdditionalRawData, string remoteAccountName, string databaseName, string containerName) : base(component, serializedAdditionalRawData, remoteAccountName)
        {
            DatabaseName = databaseName;
            ContainerName = containerName;
            Component = component;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosSqlDataTransferDataSourceSink"/> for deserialization. </summary>
        internal CosmosSqlDataTransferDataSourceSink()
        {
        }

        /// <summary> Gets or sets the database name. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; set; }
        /// <summary> Gets or sets the container name. </summary>
        [WirePath("containerName")]
        public string ContainerName { get; set; }
    }
}
