// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> A CosmosDB Mongo vCore API data source/sink. </summary>
    public partial class CosmosMongoVCoreDataTransferDataSourceSink : DataTransferDataSourceSink
    {
        /// <summary> Initializes a new instance of <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/>. </summary>
        /// <param name="databaseName"></param>
        /// <param name="collectionName"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="databaseName"/> or <paramref name="collectionName"/> is null. </exception>
        public CosmosMongoVCoreDataTransferDataSourceSink(string databaseName, string collectionName)
        {
            Argument.AssertNotNull(databaseName, nameof(databaseName));
            Argument.AssertNotNull(collectionName, nameof(collectionName));

            DatabaseName = databaseName;
            CollectionName = collectionName;
            Component = DataTransferComponent.CosmosDBMongoVCore;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/>. </summary>
        /// <param name="component"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="databaseName"></param>
        /// <param name="collectionName"></param>
        /// <param name="hostName"></param>
        /// <param name="connectionStringKeyVaultUri"></param>
        internal CosmosMongoVCoreDataTransferDataSourceSink(DataTransferComponent component, IDictionary<string, BinaryData> serializedAdditionalRawData, string databaseName, string collectionName, string hostName, Uri connectionStringKeyVaultUri) : base(component, serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            CollectionName = collectionName;
            HostName = hostName;
            ConnectionStringKeyVaultUri = connectionStringKeyVaultUri;
            Component = component;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosMongoVCoreDataTransferDataSourceSink"/> for deserialization. </summary>
        internal CosmosMongoVCoreDataTransferDataSourceSink()
        {
        }

        /// <summary> Gets or sets the database name. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; set; }
        /// <summary> Gets or sets the collection name. </summary>
        [WirePath("collectionName")]
        public string CollectionName { get; set; }
        /// <summary> Gets or sets the host name. </summary>
        [WirePath("hostName")]
        public string HostName { get; set; }
        /// <summary> Gets or sets the connection string key vault uri. </summary>
        [WirePath("connectionStringKeyVaultUri")]
        public Uri ConnectionStringKeyVaultUri { get; set; }
    }
}
