// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> A CosmosDB Mongo API data source/sink. </summary>
    public partial class CosmosMongoDataTransferDataSourceSink : BaseCosmosDataTransferDataSourceSink
    {
        /// <summary> Initializes a new instance of <see cref="CosmosMongoDataTransferDataSourceSink"/>. </summary>
        /// <param name="databaseName"></param>
        /// <param name="collectionName"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="databaseName"/> or <paramref name="collectionName"/> is null. </exception>
        public CosmosMongoDataTransferDataSourceSink(string databaseName, string collectionName)
        {
            Argument.AssertNotNull(databaseName, nameof(databaseName));
            Argument.AssertNotNull(collectionName, nameof(collectionName));

            DatabaseName = databaseName;
            CollectionName = collectionName;
            Component = DataTransferComponent.CosmosDBMongo;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosMongoDataTransferDataSourceSink"/>. </summary>
        /// <param name="component"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="remoteAccountName"></param>
        /// <param name="databaseName"></param>
        /// <param name="collectionName"></param>
        internal CosmosMongoDataTransferDataSourceSink(DataTransferComponent component, IDictionary<string, BinaryData> serializedAdditionalRawData, string remoteAccountName, string databaseName, string collectionName) : base(component, serializedAdditionalRawData, remoteAccountName)
        {
            DatabaseName = databaseName;
            CollectionName = collectionName;
            Component = component;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosMongoDataTransferDataSourceSink"/> for deserialization. </summary>
        internal CosmosMongoDataTransferDataSourceSink()
        {
        }

        /// <summary> Gets or sets the database name. </summary>
        [WirePath("databaseName")]
        public string DatabaseName { get; set; }
        /// <summary> Gets or sets the collection name. </summary>
        [WirePath("collectionName")]
        public string CollectionName { get; set; }
    }
}
