// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Type of the connection string. </summary>
    public readonly partial struct CosmosDBType : IEquatable<CosmosDBType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlValue = "Sql";
        private const string TableValue = "Table";
        private const string MongoDBValue = "MongoDB";
        private const string CassandraValue = "Cassandra";
        private const string CassandraConnectorMetadataValue = "CassandraConnectorMetadata";
        private const string GremlinValue = "Gremlin";
        private const string SqlDedicatedGatewayValue = "SqlDedicatedGateway";
        private const string GremlinV2Value = "GremlinV2";
        private const string UndefinedValue = "Undefined";

        /// <summary> Sql. </summary>
        public static CosmosDBType Sql { get; } = new CosmosDBType(SqlValue);
        /// <summary> Table. </summary>
        public static CosmosDBType Table { get; } = new CosmosDBType(TableValue);
        /// <summary> MongoDB. </summary>
        public static CosmosDBType MongoDB { get; } = new CosmosDBType(MongoDBValue);
        /// <summary> Cassandra. </summary>
        public static CosmosDBType Cassandra { get; } = new CosmosDBType(CassandraValue);
        /// <summary> CassandraConnectorMetadata. </summary>
        public static CosmosDBType CassandraConnectorMetadata { get; } = new CosmosDBType(CassandraConnectorMetadataValue);
        /// <summary> Gremlin. </summary>
        public static CosmosDBType Gremlin { get; } = new CosmosDBType(GremlinValue);
        /// <summary> SqlDedicatedGateway. </summary>
        public static CosmosDBType SqlDedicatedGateway { get; } = new CosmosDBType(SqlDedicatedGatewayValue);
        /// <summary> GremlinV2. </summary>
        public static CosmosDBType GremlinV2 { get; } = new CosmosDBType(GremlinV2Value);
        /// <summary> Undefined. </summary>
        public static CosmosDBType Undefined { get; } = new CosmosDBType(UndefinedValue);
        /// <summary> Determines if two <see cref="CosmosDBType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBType left, CosmosDBType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBType left, CosmosDBType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBType"/>. </summary>
        public static implicit operator CosmosDBType(string value) => new CosmosDBType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
