// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The operation the trigger is associated with. </summary>
    public readonly partial struct CosmosDBSqlTriggerOperation : IEquatable<CosmosDBSqlTriggerOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBSqlTriggerOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBSqlTriggerOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "All";
        private const string CreateValue = "Create";
        private const string UpdateValue = "Update";
        private const string DeleteValue = "Delete";
        private const string ReplaceValue = "Replace";

        /// <summary> All. </summary>
        public static CosmosDBSqlTriggerOperation All { get; } = new CosmosDBSqlTriggerOperation(AllValue);
        /// <summary> Create. </summary>
        public static CosmosDBSqlTriggerOperation Create { get; } = new CosmosDBSqlTriggerOperation(CreateValue);
        /// <summary> Update. </summary>
        public static CosmosDBSqlTriggerOperation Update { get; } = new CosmosDBSqlTriggerOperation(UpdateValue);
        /// <summary> Delete. </summary>
        public static CosmosDBSqlTriggerOperation Delete { get; } = new CosmosDBSqlTriggerOperation(DeleteValue);
        /// <summary> Replace. </summary>
        public static CosmosDBSqlTriggerOperation Replace { get; } = new CosmosDBSqlTriggerOperation(ReplaceValue);
        /// <summary> Determines if two <see cref="CosmosDBSqlTriggerOperation"/> values are the same. </summary>
        public static bool operator ==(CosmosDBSqlTriggerOperation left, CosmosDBSqlTriggerOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBSqlTriggerOperation"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBSqlTriggerOperation left, CosmosDBSqlTriggerOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBSqlTriggerOperation"/>. </summary>
        public static implicit operator CosmosDBSqlTriggerOperation(string value) => new CosmosDBSqlTriggerOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBSqlTriggerOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBSqlTriggerOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
