// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Parameters to create and update an Azure Cosmos DB SQL Role Assignment. </summary>
    public partial class CosmosDBSqlRoleAssignmentCreateOrUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CosmosDBSqlRoleAssignmentCreateOrUpdateContent"/>. </summary>
        public CosmosDBSqlRoleAssignmentCreateOrUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBSqlRoleAssignmentCreateOrUpdateContent"/>. </summary>
        /// <param name="roleDefinitionId"> The unique identifier for the associated Role Definition. </param>
        /// <param name="scope"> The data plane resource path for which access is being granted through this Role Assignment. </param>
        /// <param name="principalId"> The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CosmosDBSqlRoleAssignmentCreateOrUpdateContent(ResourceIdentifier roleDefinitionId, string scope, Guid? principalId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RoleDefinitionId = roleDefinitionId;
            Scope = scope;
            PrincipalId = principalId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The unique identifier for the associated Role Definition. </summary>
        [WirePath("properties.roleDefinitionId")]
        public ResourceIdentifier RoleDefinitionId { get; set; }
        /// <summary> The data plane resource path for which access is being granted through this Role Assignment. </summary>
        [WirePath("properties.scope")]
        public string Scope { get; set; }
        /// <summary> The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant associated with the subscription. </summary>
        [WirePath("properties.principalId")]
        public Guid? PrincipalId { get; set; }
    }
}
