// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates the spatial type of index. </summary>
    public readonly partial struct CosmosDBSpatialType : IEquatable<CosmosDBSpatialType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBSpatialType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBSpatialType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PointValue = "Point";
        private const string LineStringValue = "LineString";
        private const string PolygonValue = "Polygon";
        private const string MultiPolygonValue = "MultiPolygon";

        /// <summary> Point. </summary>
        public static CosmosDBSpatialType Point { get; } = new CosmosDBSpatialType(PointValue);
        /// <summary> LineString. </summary>
        public static CosmosDBSpatialType LineString { get; } = new CosmosDBSpatialType(LineStringValue);
        /// <summary> Polygon. </summary>
        public static CosmosDBSpatialType Polygon { get; } = new CosmosDBSpatialType(PolygonValue);
        /// <summary> MultiPolygon. </summary>
        public static CosmosDBSpatialType MultiPolygon { get; } = new CosmosDBSpatialType(MultiPolygonValue);
        /// <summary> Determines if two <see cref="CosmosDBSpatialType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBSpatialType left, CosmosDBSpatialType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBSpatialType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBSpatialType left, CosmosDBSpatialType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBSpatialType"/>. </summary>
        public static implicit operator CosmosDBSpatialType(string value) => new CosmosDBSpatialType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBSpatialType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBSpatialType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
