// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> ServiceType for the service. </summary>
    public readonly partial struct CosmosDBServiceType : IEquatable<CosmosDBServiceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBServiceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBServiceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlDedicatedGatewayValue = "SqlDedicatedGateway";
        private const string DataTransferValue = "DataTransfer";
        private const string GraphApiComputeValue = "GraphAPICompute";
        private const string MaterializedViewsBuilderValue = "MaterializedViewsBuilder";

        /// <summary> SqlDedicatedGateway. </summary>
        public static CosmosDBServiceType SqlDedicatedGateway { get; } = new CosmosDBServiceType(SqlDedicatedGatewayValue);
        /// <summary> DataTransfer. </summary>
        public static CosmosDBServiceType DataTransfer { get; } = new CosmosDBServiceType(DataTransferValue);
        /// <summary> GraphAPICompute. </summary>
        public static CosmosDBServiceType GraphApiCompute { get; } = new CosmosDBServiceType(GraphApiComputeValue);
        /// <summary> MaterializedViewsBuilder. </summary>
        public static CosmosDBServiceType MaterializedViewsBuilder { get; } = new CosmosDBServiceType(MaterializedViewsBuilderValue);
        /// <summary> Determines if two <see cref="CosmosDBServiceType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBServiceType left, CosmosDBServiceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBServiceType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBServiceType left, CosmosDBServiceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBServiceType"/>. </summary>
        public static implicit operator CosmosDBServiceType(string value) => new CosmosDBServiceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBServiceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBServiceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
