// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Instance type for the service. </summary>
    public readonly partial struct CosmosDBServiceSize : IEquatable<CosmosDBServiceSize>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBServiceSize"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBServiceSize(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CosmosD4SValue = "Cosmos.D4s";
        private const string CosmosD8SValue = "Cosmos.D8s";
        private const string CosmosD16SValue = "Cosmos.D16s";

        /// <summary> Cosmos.D4s. </summary>
        public static CosmosDBServiceSize CosmosD4S { get; } = new CosmosDBServiceSize(CosmosD4SValue);
        /// <summary> Cosmos.D8s. </summary>
        public static CosmosDBServiceSize CosmosD8S { get; } = new CosmosDBServiceSize(CosmosD8SValue);
        /// <summary> Cosmos.D16s. </summary>
        public static CosmosDBServiceSize CosmosD16S { get; } = new CosmosDBServiceSize(CosmosD16SValue);
        /// <summary> Determines if two <see cref="CosmosDBServiceSize"/> values are the same. </summary>
        public static bool operator ==(CosmosDBServiceSize left, CosmosDBServiceSize right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBServiceSize"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBServiceSize left, CosmosDBServiceSize right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBServiceSize"/>. </summary>
        public static implicit operator CosmosDBServiceSize(string value) => new CosmosDBServiceSize(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBServiceSize other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBServiceSize other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
