// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The indexes for the path. </summary>
    public partial class CosmosDBPathIndexes
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CosmosDBPathIndexes"/>. </summary>
        public CosmosDBPathIndexes()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBPathIndexes"/>. </summary>
        /// <param name="dataType"> The datatype for which the indexing behavior is applied to. </param>
        /// <param name="precision"> The precision of the index. -1 is maximum precision. </param>
        /// <param name="kind"> Indicates the type of index. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CosmosDBPathIndexes(CosmosDBDataType? dataType, int? precision, CosmosDBIndexKind? kind, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataType = dataType;
            Precision = precision;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The datatype for which the indexing behavior is applied to. </summary>
        [WirePath("dataType")]
        public CosmosDBDataType? DataType { get; set; }
        /// <summary> The precision of the index. -1 is maximum precision. </summary>
        [WirePath("precision")]
        public int? Precision { get; set; }
        /// <summary> Indicates the type of index. </summary>
        [WirePath("kind")]
        public CosmosDBIndexKind? Kind { get; set; }
    }
}
