// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are supported for container create. </summary>
    public readonly partial struct CosmosDBPartitionKind : IEquatable<CosmosDBPartitionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBPartitionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBPartitionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HashValue = "Hash";
        private const string RangeValue = "Range";
        private const string MultiHashValue = "MultiHash";

        /// <summary> Hash. </summary>
        public static CosmosDBPartitionKind Hash { get; } = new CosmosDBPartitionKind(HashValue);
        /// <summary> Range. </summary>
        public static CosmosDBPartitionKind Range { get; } = new CosmosDBPartitionKind(RangeValue);
        /// <summary> MultiHash. </summary>
        public static CosmosDBPartitionKind MultiHash { get; } = new CosmosDBPartitionKind(MultiHashValue);
        /// <summary> Determines if two <see cref="CosmosDBPartitionKind"/> values are the same. </summary>
        public static bool operator ==(CosmosDBPartitionKind left, CosmosDBPartitionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBPartitionKind"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBPartitionKind left, CosmosDBPartitionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBPartitionKind"/>. </summary>
        public static implicit operator CosmosDBPartitionKind(string value) => new CosmosDBPartitionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBPartitionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBPartitionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
