// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work with Tls 1.2. </summary>
    public readonly partial struct CosmosDBMinimalTlsVersion : IEquatable<CosmosDBMinimalTlsVersion>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBMinimalTlsVersion"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBMinimalTlsVersion(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TlsValue = "Tls";
        private const string Tls11Value = "Tls11";
        private const string Tls12Value = "Tls12";

        /// <summary> Tls. </summary>
        public static CosmosDBMinimalTlsVersion Tls { get; } = new CosmosDBMinimalTlsVersion(TlsValue);
        /// <summary> Tls11. </summary>
        public static CosmosDBMinimalTlsVersion Tls11 { get; } = new CosmosDBMinimalTlsVersion(Tls11Value);
        /// <summary> Tls12. </summary>
        public static CosmosDBMinimalTlsVersion Tls12 { get; } = new CosmosDBMinimalTlsVersion(Tls12Value);
        /// <summary> Determines if two <see cref="CosmosDBMinimalTlsVersion"/> values are the same. </summary>
        public static bool operator ==(CosmosDBMinimalTlsVersion left, CosmosDBMinimalTlsVersion right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBMinimalTlsVersion"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBMinimalTlsVersion left, CosmosDBMinimalTlsVersion right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBMinimalTlsVersion"/>. </summary>
        public static implicit operator CosmosDBMinimalTlsVersion(string value) => new CosmosDBMinimalTlsVersion(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBMinimalTlsVersion other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBMinimalTlsVersion other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
