// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The unit of the metric. </summary>
    public readonly partial struct CosmosDBMetricUnitType : IEquatable<CosmosDBMetricUnitType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBMetricUnitType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBMetricUnitType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";
        private const string BytesValue = "Bytes";
        private const string SecondsValue = "Seconds";
        private const string PercentValue = "Percent";
        private const string CountPerSecondValue = "CountPerSecond";
        private const string BytesPerSecondValue = "BytesPerSecond";
        private const string MillisecondsValue = "Milliseconds";

        /// <summary> Count. </summary>
        public static CosmosDBMetricUnitType Count { get; } = new CosmosDBMetricUnitType(CountValue);
        /// <summary> Bytes. </summary>
        public static CosmosDBMetricUnitType Bytes { get; } = new CosmosDBMetricUnitType(BytesValue);
        /// <summary> Seconds. </summary>
        public static CosmosDBMetricUnitType Seconds { get; } = new CosmosDBMetricUnitType(SecondsValue);
        /// <summary> Percent. </summary>
        public static CosmosDBMetricUnitType Percent { get; } = new CosmosDBMetricUnitType(PercentValue);
        /// <summary> CountPerSecond. </summary>
        public static CosmosDBMetricUnitType CountPerSecond { get; } = new CosmosDBMetricUnitType(CountPerSecondValue);
        /// <summary> BytesPerSecond. </summary>
        public static CosmosDBMetricUnitType BytesPerSecond { get; } = new CosmosDBMetricUnitType(BytesPerSecondValue);
        /// <summary> Milliseconds. </summary>
        public static CosmosDBMetricUnitType Milliseconds { get; } = new CosmosDBMetricUnitType(MillisecondsValue);
        /// <summary> Determines if two <see cref="CosmosDBMetricUnitType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBMetricUnitType left, CosmosDBMetricUnitType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBMetricUnitType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBMetricUnitType left, CosmosDBMetricUnitType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBMetricUnitType"/>. </summary>
        public static implicit operator CosmosDBMetricUnitType(string value) => new CosmosDBMetricUnitType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBMetricUnitType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBMetricUnitType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
