// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The primary aggregation type of the metric. </summary>
    public readonly partial struct CosmosDBMetricPrimaryAggregationType : IEquatable<CosmosDBMetricPrimaryAggregationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBMetricPrimaryAggregationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBMetricPrimaryAggregationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string AverageValue = "Average";
        private const string TotalValue = "Total";
        private const string MinimumValue = "Minimum";
        private const string MaximumValue = "Maximum";
        private const string LastValue = "Last";

        /// <summary> None. </summary>
        public static CosmosDBMetricPrimaryAggregationType None { get; } = new CosmosDBMetricPrimaryAggregationType(NoneValue);
        /// <summary> Average. </summary>
        public static CosmosDBMetricPrimaryAggregationType Average { get; } = new CosmosDBMetricPrimaryAggregationType(AverageValue);
        /// <summary> Total. </summary>
        public static CosmosDBMetricPrimaryAggregationType Total { get; } = new CosmosDBMetricPrimaryAggregationType(TotalValue);
        /// <summary> Minimum. </summary>
        public static CosmosDBMetricPrimaryAggregationType Minimum { get; } = new CosmosDBMetricPrimaryAggregationType(MinimumValue);
        /// <summary> Maximum. </summary>
        public static CosmosDBMetricPrimaryAggregationType Maximum { get; } = new CosmosDBMetricPrimaryAggregationType(MaximumValue);
        /// <summary> Last. </summary>
        public static CosmosDBMetricPrimaryAggregationType Last { get; } = new CosmosDBMetricPrimaryAggregationType(LastValue);
        /// <summary> Determines if two <see cref="CosmosDBMetricPrimaryAggregationType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBMetricPrimaryAggregationType left, CosmosDBMetricPrimaryAggregationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBMetricPrimaryAggregationType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBMetricPrimaryAggregationType left, CosmosDBMetricPrimaryAggregationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBMetricPrimaryAggregationType"/>. </summary>
        public static implicit operator CosmosDBMetricPrimaryAggregationType(string value) => new CosmosDBMetricPrimaryAggregationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBMetricPrimaryAggregationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBMetricPrimaryAggregationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
