// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class CosmosDBFailoverPolicies : IUtf8JsonSerializable, IJsonModel<CosmosDBFailoverPolicies>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CosmosDBFailoverPolicies>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CosmosDBFailoverPolicies>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBFailoverPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBFailoverPolicies)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("failoverPolicies"u8);
            writer.WriteStartArray();
            foreach (var item in FailoverPolicies)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CosmosDBFailoverPolicies IJsonModel<CosmosDBFailoverPolicies>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBFailoverPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBFailoverPolicies)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCosmosDBFailoverPolicies(document.RootElement, options);
        }

        internal static CosmosDBFailoverPolicies DeserializeCosmosDBFailoverPolicies(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<CosmosDBFailoverPolicy> failoverPolicies = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("failoverPolicies"u8))
                {
                    List<CosmosDBFailoverPolicy> array = new List<CosmosDBFailoverPolicy>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CosmosDBFailoverPolicy.DeserializeCosmosDBFailoverPolicy(item, options));
                    }
                    failoverPolicies = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CosmosDBFailoverPolicies(failoverPolicies, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CosmosDBFailoverPolicies>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBFailoverPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CosmosDBFailoverPolicies)} does not support writing '{options.Format}' format.");
            }
        }

        CosmosDBFailoverPolicies IPersistableModel<CosmosDBFailoverPolicies>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBFailoverPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCosmosDBFailoverPolicies(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CosmosDBFailoverPolicies)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CosmosDBFailoverPolicies>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
