// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The datatype for which the indexing behavior is applied to. </summary>
    public readonly partial struct CosmosDBDataType : IEquatable<CosmosDBDataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBDataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBDataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StringValue = "String";
        private const string NumberValue = "Number";
        private const string PointValue = "Point";
        private const string PolygonValue = "Polygon";
        private const string LineStringValue = "LineString";
        private const string MultiPolygonValue = "MultiPolygon";

        /// <summary> String. </summary>
        public static CosmosDBDataType String { get; } = new CosmosDBDataType(StringValue);
        /// <summary> Number. </summary>
        public static CosmosDBDataType Number { get; } = new CosmosDBDataType(NumberValue);
        /// <summary> Point. </summary>
        public static CosmosDBDataType Point { get; } = new CosmosDBDataType(PointValue);
        /// <summary> Polygon. </summary>
        public static CosmosDBDataType Polygon { get; } = new CosmosDBDataType(PolygonValue);
        /// <summary> LineString. </summary>
        public static CosmosDBDataType LineString { get; } = new CosmosDBDataType(LineStringValue);
        /// <summary> MultiPolygon. </summary>
        public static CosmosDBDataType MultiPolygon { get; } = new CosmosDBDataType(MultiPolygonValue);
        /// <summary> Determines if two <see cref="CosmosDBDataType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBDataType left, CosmosDBDataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBDataType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBDataType left, CosmosDBDataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBDataType"/>. </summary>
        public static implicit operator CosmosDBDataType(string value) => new CosmosDBDataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBDataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBDataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
