// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Cosmos DB client encryption policy. </summary>
    public partial class CosmosDBClientEncryptionPolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CosmosDBClientEncryptionPolicy"/>. </summary>
        /// <param name="includedPaths"> Paths of the item that need encryption along with path-specific settings. </param>
        /// <param name="policyFormatVersion"> Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="includedPaths"/> is null. </exception>
        public CosmosDBClientEncryptionPolicy(IEnumerable<CosmosDBClientEncryptionIncludedPath> includedPaths, int policyFormatVersion)
        {
            Argument.AssertNotNull(includedPaths, nameof(includedPaths));

            IncludedPaths = includedPaths.ToList();
            PolicyFormatVersion = policyFormatVersion;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBClientEncryptionPolicy"/>. </summary>
        /// <param name="includedPaths"> Paths of the item that need encryption along with path-specific settings. </param>
        /// <param name="policyFormatVersion"> Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CosmosDBClientEncryptionPolicy(IList<CosmosDBClientEncryptionIncludedPath> includedPaths, int policyFormatVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IncludedPaths = includedPaths;
            PolicyFormatVersion = policyFormatVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBClientEncryptionPolicy"/> for deserialization. </summary>
        internal CosmosDBClientEncryptionPolicy()
        {
        }

        /// <summary> Paths of the item that need encryption along with path-specific settings. </summary>
        [WirePath("includedPaths")]
        public IList<CosmosDBClientEncryptionIncludedPath> IncludedPaths { get; }
        /// <summary> Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and partition key path encryption. </summary>
        [WirePath("policyFormatVersion")]
        public int PolicyFormatVersion { get; set; }
    }
}
