// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Enum to indicate type of backup storage redundancy. </summary>
    public readonly partial struct CosmosDBBackupStorageRedundancy : IEquatable<CosmosDBBackupStorageRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBBackupStorageRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBBackupStorageRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeoValue = "Geo";
        private const string LocalValue = "Local";
        private const string ZoneValue = "Zone";

        /// <summary> Geo. </summary>
        public static CosmosDBBackupStorageRedundancy Geo { get; } = new CosmosDBBackupStorageRedundancy(GeoValue);
        /// <summary> Local. </summary>
        public static CosmosDBBackupStorageRedundancy Local { get; } = new CosmosDBBackupStorageRedundancy(LocalValue);
        /// <summary> Zone. </summary>
        public static CosmosDBBackupStorageRedundancy Zone { get; } = new CosmosDBBackupStorageRedundancy(ZoneValue);
        /// <summary> Determines if two <see cref="CosmosDBBackupStorageRedundancy"/> values are the same. </summary>
        public static bool operator ==(CosmosDBBackupStorageRedundancy left, CosmosDBBackupStorageRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBBackupStorageRedundancy"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBBackupStorageRedundancy left, CosmosDBBackupStorageRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBBackupStorageRedundancy"/>. </summary>
        public static implicit operator CosmosDBBackupStorageRedundancy(string value) => new CosmosDBBackupStorageRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBBackupStorageRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBBackupStorageRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
