// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Enum to indicate the API type of the restorable database account. </summary>
    public readonly partial struct CosmosDBApiType : IEquatable<CosmosDBApiType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CosmosDBApiType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CosmosDBApiType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MongoDBValue = "MongoDB";
        private const string GremlinValue = "Gremlin";
        private const string CassandraValue = "Cassandra";
        private const string TableValue = "Table";
        private const string SqlValue = "Sql";
        private const string GremlinV2Value = "GremlinV2";

        /// <summary> MongoDB. </summary>
        public static CosmosDBApiType MongoDB { get; } = new CosmosDBApiType(MongoDBValue);
        /// <summary> Gremlin. </summary>
        public static CosmosDBApiType Gremlin { get; } = new CosmosDBApiType(GremlinValue);
        /// <summary> Cassandra. </summary>
        public static CosmosDBApiType Cassandra { get; } = new CosmosDBApiType(CassandraValue);
        /// <summary> Table. </summary>
        public static CosmosDBApiType Table { get; } = new CosmosDBApiType(TableValue);
        /// <summary> Sql. </summary>
        public static CosmosDBApiType Sql { get; } = new CosmosDBApiType(SqlValue);
        /// <summary> GremlinV2. </summary>
        public static CosmosDBApiType GremlinV2 { get; } = new CosmosDBApiType(GremlinV2Value);
        /// <summary> Determines if two <see cref="CosmosDBApiType"/> values are the same. </summary>
        public static bool operator ==(CosmosDBApiType left, CosmosDBApiType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CosmosDBApiType"/> values are not the same. </summary>
        public static bool operator !=(CosmosDBApiType left, CosmosDBApiType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CosmosDBApiType"/>. </summary>
        public static implicit operator CosmosDBApiType(string value) => new CosmosDBApiType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CosmosDBApiType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CosmosDBApiType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
