// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Parameters to indicate the information about the restore. </summary>
    public partial class CosmosDBAccountRestoreParameters : RestoreParametersBase
    {
        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountRestoreParameters"/>. </summary>
        public CosmosDBAccountRestoreParameters()
        {
            DatabasesToRestore = new ChangeTrackingList<DatabaseRestoreResourceInfo>();
            GremlinDatabasesToRestore = new ChangeTrackingList<GremlinDatabaseRestoreResourceInfo>();
            TablesToRestore = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountRestoreParameters"/>. </summary>
        /// <param name="restoreSource"> The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}. </param>
        /// <param name="restoreTimestampInUtc"> Time to which the account has to be restored (ISO-8601 format). </param>
        /// <param name="isRestoreWithTtlDisabled"> Specifies whether the restored account will have Time-To-Live disabled upon the successful restore. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="restoreMode"> Describes the mode of the restore. </param>
        /// <param name="databasesToRestore"> List of specific databases available for restore. </param>
        /// <param name="gremlinDatabasesToRestore"> List of specific gremlin databases available for restore. </param>
        /// <param name="tablesToRestore"> List of specific tables available for restore. </param>
        /// <param name="sourceBackupLocation"> The source backup location for restore. </param>
        internal CosmosDBAccountRestoreParameters(string restoreSource, DateTimeOffset? restoreTimestampInUtc, bool? isRestoreWithTtlDisabled, IDictionary<string, BinaryData> serializedAdditionalRawData, CosmosDBAccountRestoreMode? restoreMode, IList<DatabaseRestoreResourceInfo> databasesToRestore, IList<GremlinDatabaseRestoreResourceInfo> gremlinDatabasesToRestore, IList<string> tablesToRestore, string sourceBackupLocation) : base(restoreSource, restoreTimestampInUtc, isRestoreWithTtlDisabled, serializedAdditionalRawData)
        {
            RestoreMode = restoreMode;
            DatabasesToRestore = databasesToRestore;
            GremlinDatabasesToRestore = gremlinDatabasesToRestore;
            TablesToRestore = tablesToRestore;
            SourceBackupLocation = sourceBackupLocation;
        }

        /// <summary> Describes the mode of the restore. </summary>
        [WirePath("restoreMode")]
        public CosmosDBAccountRestoreMode? RestoreMode { get; set; }
        /// <summary> List of specific databases available for restore. </summary>
        [WirePath("databasesToRestore")]
        public IList<DatabaseRestoreResourceInfo> DatabasesToRestore { get; }
        /// <summary> List of specific gremlin databases available for restore. </summary>
        [WirePath("gremlinDatabasesToRestore")]
        public IList<GremlinDatabaseRestoreResourceInfo> GremlinDatabasesToRestore { get; }
        /// <summary> List of specific tables available for restore. </summary>
        [WirePath("tablesToRestore")]
        public IList<string> TablesToRestore { get; }
        /// <summary> The source backup location for restore. </summary>
        [WirePath("sourceBackupLocation")]
        public string SourceBackupLocation { get; set; }
    }
}
