// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The access keys for the given database account. </summary>
    public partial class CosmosDBAccountKeyList : CosmosDBAccountReadOnlyKeyList
    {
        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountKeyList"/>. </summary>
        internal CosmosDBAccountKeyList()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CosmosDBAccountKeyList"/>. </summary>
        /// <param name="primaryReadonlyMasterKey"> Base 64 encoded value of the primary read-only key. </param>
        /// <param name="secondaryReadonlyMasterKey"> Base 64 encoded value of the secondary read-only key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="primaryMasterKey"> Base 64 encoded value of the primary read-write key. </param>
        /// <param name="secondaryMasterKey"> Base 64 encoded value of the secondary read-write key. </param>
        internal CosmosDBAccountKeyList(string primaryReadonlyMasterKey, string secondaryReadonlyMasterKey, IDictionary<string, BinaryData> serializedAdditionalRawData, string primaryMasterKey, string secondaryMasterKey) : base(primaryReadonlyMasterKey, secondaryReadonlyMasterKey, serializedAdditionalRawData)
        {
            PrimaryMasterKey = primaryMasterKey;
            SecondaryMasterKey = secondaryMasterKey;
        }

        /// <summary> Base 64 encoded value of the primary read-write key. </summary>
        [WirePath("primaryMasterKey")]
        public string PrimaryMasterKey { get; }
        /// <summary> Base 64 encoded value of the secondary read-write key. </summary>
        [WirePath("secondaryMasterKey")]
        public string SecondaryMasterKey { get; }
    }
}
