// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class CosmosDBAccountKeyList : IUtf8JsonSerializable, IJsonModel<CosmosDBAccountKeyList>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CosmosDBAccountKeyList>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CosmosDBAccountKeyList>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountKeyList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBAccountKeyList)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(PrimaryMasterKey))
            {
                writer.WritePropertyName("primaryMasterKey"u8);
                writer.WriteStringValue(PrimaryMasterKey);
            }
            if (options.Format != "W" && Optional.IsDefined(SecondaryMasterKey))
            {
                writer.WritePropertyName("secondaryMasterKey"u8);
                writer.WriteStringValue(SecondaryMasterKey);
            }
        }

        CosmosDBAccountKeyList IJsonModel<CosmosDBAccountKeyList>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountKeyList>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CosmosDBAccountKeyList)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCosmosDBAccountKeyList(document.RootElement, options);
        }

        internal static CosmosDBAccountKeyList DeserializeCosmosDBAccountKeyList(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string primaryMasterKey = default;
            string secondaryMasterKey = default;
            string primaryReadonlyMasterKey = default;
            string secondaryReadonlyMasterKey = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("primaryMasterKey"u8))
                {
                    primaryMasterKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryMasterKey"u8))
                {
                    secondaryMasterKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("primaryReadonlyMasterKey"u8))
                {
                    primaryReadonlyMasterKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryReadonlyMasterKey"u8))
                {
                    secondaryReadonlyMasterKey = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CosmosDBAccountKeyList(primaryReadonlyMasterKey, secondaryReadonlyMasterKey, serializedAdditionalRawData, primaryMasterKey, secondaryMasterKey);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrimaryMasterKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  primaryMasterKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrimaryMasterKey))
                {
                    builder.Append("  primaryMasterKey: ");
                    if (PrimaryMasterKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrimaryMasterKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrimaryMasterKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecondaryMasterKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secondaryMasterKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecondaryMasterKey))
                {
                    builder.Append("  secondaryMasterKey: ");
                    if (SecondaryMasterKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SecondaryMasterKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SecondaryMasterKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrimaryReadonlyMasterKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  primaryReadonlyMasterKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrimaryReadonlyMasterKey))
                {
                    builder.Append("  primaryReadonlyMasterKey: ");
                    if (PrimaryReadonlyMasterKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrimaryReadonlyMasterKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrimaryReadonlyMasterKey}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecondaryReadonlyMasterKey), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  secondaryReadonlyMasterKey: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecondaryReadonlyMasterKey))
                {
                    builder.Append("  secondaryReadonlyMasterKey: ");
                    if (SecondaryReadonlyMasterKey.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SecondaryReadonlyMasterKey}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SecondaryReadonlyMasterKey}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CosmosDBAccountKeyList>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountKeyList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CosmosDBAccountKeyList)} does not support writing '{options.Format}' format.");
            }
        }

        CosmosDBAccountKeyList IPersistableModel<CosmosDBAccountKeyList>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CosmosDBAccountKeyList>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCosmosDBAccountKeyList(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CosmosDBAccountKeyList)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CosmosDBAccountKeyList>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
