// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class ConsistencyPolicy : IUtf8JsonSerializable, IJsonModel<ConsistencyPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsistencyPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsistencyPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsistencyPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsistencyPolicy)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("defaultConsistencyLevel"u8);
            writer.WriteStringValue(DefaultConsistencyLevel.ToSerialString());
            if (Optional.IsDefined(MaxStalenessPrefix))
            {
                writer.WritePropertyName("maxStalenessPrefix"u8);
                writer.WriteNumberValue(MaxStalenessPrefix.Value);
            }
            if (Optional.IsDefined(MaxIntervalInSeconds))
            {
                writer.WritePropertyName("maxIntervalInSeconds"u8);
                writer.WriteNumberValue(MaxIntervalInSeconds.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConsistencyPolicy IJsonModel<ConsistencyPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsistencyPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsistencyPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsistencyPolicy(document.RootElement, options);
        }

        internal static ConsistencyPolicy DeserializeConsistencyPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DefaultConsistencyLevel defaultConsistencyLevel = default;
            long? maxStalenessPrefix = default;
            int? maxIntervalInSeconds = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("defaultConsistencyLevel"u8))
                {
                    defaultConsistencyLevel = property.Value.GetString().ToDefaultConsistencyLevel();
                    continue;
                }
                if (property.NameEquals("maxStalenessPrefix"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxStalenessPrefix = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("maxIntervalInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxIntervalInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsistencyPolicy(defaultConsistencyLevel, maxStalenessPrefix, maxIntervalInSeconds, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultConsistencyLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  defaultConsistencyLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  defaultConsistencyLevel: ");
                builder.AppendLine($"'{DefaultConsistencyLevel.ToSerialString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxStalenessPrefix), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maxStalenessPrefix: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxStalenessPrefix))
                {
                    builder.Append("  maxStalenessPrefix: ");
                    builder.AppendLine($"'{MaxStalenessPrefix.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MaxIntervalInSeconds), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  maxIntervalInSeconds: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MaxIntervalInSeconds))
                {
                    builder.Append("  maxIntervalInSeconds: ");
                    builder.AppendLine($"{MaxIntervalInSeconds.Value}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ConsistencyPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsistencyPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ConsistencyPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ConsistencyPolicy IPersistableModel<ConsistencyPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsistencyPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsistencyPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsistencyPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsistencyPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
