// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class ConflictResolutionPolicy : IUtf8JsonSerializable, IJsonModel<ConflictResolutionPolicy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConflictResolutionPolicy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConflictResolutionPolicy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConflictResolutionPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConflictResolutionPolicy)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Mode))
            {
                writer.WritePropertyName("mode"u8);
                writer.WriteStringValue(Mode.Value.ToString());
            }
            if (Optional.IsDefined(ConflictResolutionPath))
            {
                writer.WritePropertyName("conflictResolutionPath"u8);
                writer.WriteStringValue(ConflictResolutionPath);
            }
            if (Optional.IsDefined(ConflictResolutionProcedure))
            {
                writer.WritePropertyName("conflictResolutionProcedure"u8);
                writer.WriteStringValue(ConflictResolutionProcedure);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConflictResolutionPolicy IJsonModel<ConflictResolutionPolicy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConflictResolutionPolicy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConflictResolutionPolicy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConflictResolutionPolicy(document.RootElement, options);
        }

        internal static ConflictResolutionPolicy DeserializeConflictResolutionPolicy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ConflictResolutionMode? mode = default;
            string conflictResolutionPath = default;
            string conflictResolutionProcedure = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("mode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mode = new ConflictResolutionMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("conflictResolutionPath"u8))
                {
                    conflictResolutionPath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("conflictResolutionProcedure"u8))
                {
                    conflictResolutionProcedure = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConflictResolutionPolicy(mode, conflictResolutionPath, conflictResolutionProcedure, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Mode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  mode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Mode))
                {
                    builder.Append("  mode: ");
                    builder.AppendLine($"'{Mode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConflictResolutionPath), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  conflictResolutionPath: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConflictResolutionPath))
                {
                    builder.Append("  conflictResolutionPath: ");
                    if (ConflictResolutionPath.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ConflictResolutionPath}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ConflictResolutionPath}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConflictResolutionProcedure), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  conflictResolutionProcedure: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ConflictResolutionProcedure))
                {
                    builder.Append("  conflictResolutionProcedure: ");
                    if (ConflictResolutionProcedure.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ConflictResolutionProcedure}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ConflictResolutionProcedure}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ConflictResolutionPolicy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConflictResolutionPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ConflictResolutionPolicy)} does not support writing '{options.Format}' format.");
            }
        }

        ConflictResolutionPolicy IPersistableModel<ConflictResolutionPolicy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConflictResolutionPolicy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConflictResolutionPolicy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConflictResolutionPolicy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConflictResolutionPolicy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
