// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates the conflict resolution mode. </summary>
    public readonly partial struct ConflictResolutionMode : IEquatable<ConflictResolutionMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConflictResolutionMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConflictResolutionMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LastWriterWinsValue = "LastWriterWins";
        private const string CustomValue = "Custom";

        /// <summary> LastWriterWins. </summary>
        public static ConflictResolutionMode LastWriterWins { get; } = new ConflictResolutionMode(LastWriterWinsValue);
        /// <summary> Custom. </summary>
        public static ConflictResolutionMode Custom { get; } = new ConflictResolutionMode(CustomValue);
        /// <summary> Determines if two <see cref="ConflictResolutionMode"/> values are the same. </summary>
        public static bool operator ==(ConflictResolutionMode left, ConflictResolutionMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConflictResolutionMode"/> values are not the same. </summary>
        public static bool operator !=(ConflictResolutionMode left, ConflictResolutionMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConflictResolutionMode"/>. </summary>
        public static implicit operator ConflictResolutionMode(string value) => new ConflictResolutionMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConflictResolutionMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConflictResolutionMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
