// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Sort order for composite paths. </summary>
    public readonly partial struct CompositePathSortOrder : IEquatable<CompositePathSortOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CompositePathSortOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CompositePathSortOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AscendingValue = "ascending";
        private const string DescendingValue = "descending";

        /// <summary> ascending. </summary>
        public static CompositePathSortOrder Ascending { get; } = new CompositePathSortOrder(AscendingValue);
        /// <summary> descending. </summary>
        public static CompositePathSortOrder Descending { get; } = new CompositePathSortOrder(DescendingValue);
        /// <summary> Determines if two <see cref="CompositePathSortOrder"/> values are the same. </summary>
        public static bool operator ==(CompositePathSortOrder left, CompositePathSortOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CompositePathSortOrder"/> values are not the same. </summary>
        public static bool operator !=(CompositePathSortOrder left, CompositePathSortOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CompositePathSortOrder"/>. </summary>
        public static implicit operator CompositePathSortOrder(string value) => new CompositePathSortOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CompositePathSortOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CompositePathSortOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
