// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The CassandraViewGetPropertiesResource. </summary>
    public partial class CassandraViewGetPropertiesResource : CassandraViewResource
    {
        /// <summary> Initializes a new instance of <see cref="CassandraViewGetPropertiesResource"/>. </summary>
        /// <param name="id"> Name of the Cosmos DB Cassandra view. </param>
        /// <param name="viewDefinition"> View Definition of the Cosmos DB Cassandra view. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> or <paramref name="viewDefinition"/> is null. </exception>
        public CassandraViewGetPropertiesResource(string id, string viewDefinition) : base(id, viewDefinition)
        {
            Argument.AssertNotNull(id, nameof(id));
            Argument.AssertNotNull(viewDefinition, nameof(viewDefinition));
        }

        /// <summary> Initializes a new instance of <see cref="CassandraViewGetPropertiesResource"/>. </summary>
        /// <param name="id"> Name of the Cosmos DB Cassandra view. </param>
        /// <param name="viewDefinition"> View Definition of the Cosmos DB Cassandra view. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="rid"> A system generated property. A unique identifier. </param>
        /// <param name="timestamp"> A system generated property that denotes the last updated timestamp of the resource. </param>
        /// <param name="etag"> A system generated property representing the resource etag required for optimistic concurrency control. </param>
        internal CassandraViewGetPropertiesResource(string id, string viewDefinition, IDictionary<string, BinaryData> serializedAdditionalRawData, string rid, float? timestamp, ETag? etag) : base(id, viewDefinition, serializedAdditionalRawData)
        {
            Rid = rid;
            Timestamp = timestamp;
            ETag = etag;
        }

        /// <summary> Initializes a new instance of <see cref="CassandraViewGetPropertiesResource"/> for deserialization. </summary>
        internal CassandraViewGetPropertiesResource()
        {
        }

        /// <summary> A system generated property. A unique identifier. </summary>
        [WirePath("_rid")]
        public string Rid { get; }
        /// <summary> A system generated property that denotes the last updated timestamp of the resource. </summary>
        [WirePath("_ts")]
        public float? Timestamp { get; }
        /// <summary> A system generated property representing the resource etag required for optimistic concurrency control. </summary>
        [WirePath("_etag")]
        public ETag? ETag { get; }
    }
}
