// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The CassandraReaperStatus. </summary>
    public partial class CassandraReaperStatus
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraReaperStatus"/>. </summary>
        internal CassandraReaperStatus()
        {
            RepairRunIds = new ChangeTrackingDictionary<string, string>();
            RepairSchedules = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="CassandraReaperStatus"/>. </summary>
        /// <param name="isHealthy"></param>
        /// <param name="repairRunIds"> Dictionary of &lt;string&gt;. </param>
        /// <param name="repairSchedules"> Dictionary of &lt;string&gt;. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraReaperStatus(bool? isHealthy, IReadOnlyDictionary<string, string> repairRunIds, IReadOnlyDictionary<string, string> repairSchedules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsHealthy = isHealthy;
            RepairRunIds = repairRunIds;
            RepairSchedules = repairSchedules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the is healthy. </summary>
        [WirePath("healthy")]
        public bool? IsHealthy { get; }
        /// <summary> Dictionary of &lt;string&gt;. </summary>
        [WirePath("repairRunIds")]
        public IReadOnlyDictionary<string, string> RepairRunIds { get; }
        /// <summary> Dictionary of &lt;string&gt;. </summary>
        [WirePath("repairSchedules")]
        public IReadOnlyDictionary<string, string> RepairSchedules { get; }
    }
}
