// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The status of the resource at the time the operation was called. </summary>
    public readonly partial struct CassandraProvisioningState : IEquatable<CassandraProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static CassandraProvisioningState Creating { get; } = new CassandraProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static CassandraProvisioningState Updating { get; } = new CassandraProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static CassandraProvisioningState Deleting { get; } = new CassandraProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static CassandraProvisioningState Succeeded { get; } = new CassandraProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static CassandraProvisioningState Failed { get; } = new CassandraProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static CassandraProvisioningState Canceled { get; } = new CassandraProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="CassandraProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CassandraProvisioningState left, CassandraProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CassandraProvisioningState left, CassandraProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraProvisioningState"/>. </summary>
        public static implicit operator CassandraProvisioningState(string value) => new CassandraProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
