// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The state of the node in Cassandra ring. </summary>
    public readonly partial struct CassandraNodeState : IEquatable<CassandraNodeState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraNodeState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraNodeState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NormalValue = "Normal";
        private const string LeavingValue = "Leaving";
        private const string JoiningValue = "Joining";
        private const string MovingValue = "Moving";
        private const string StoppedValue = "Stopped";

        /// <summary> Normal. </summary>
        public static CassandraNodeState Normal { get; } = new CassandraNodeState(NormalValue);
        /// <summary> Leaving. </summary>
        public static CassandraNodeState Leaving { get; } = new CassandraNodeState(LeavingValue);
        /// <summary> Joining. </summary>
        public static CassandraNodeState Joining { get; } = new CassandraNodeState(JoiningValue);
        /// <summary> Moving. </summary>
        public static CassandraNodeState Moving { get; } = new CassandraNodeState(MovingValue);
        /// <summary> Stopped. </summary>
        public static CassandraNodeState Stopped { get; } = new CassandraNodeState(StoppedValue);
        /// <summary> Determines if two <see cref="CassandraNodeState"/> values are the same. </summary>
        public static bool operator ==(CassandraNodeState left, CassandraNodeState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraNodeState"/> values are not the same. </summary>
        public static bool operator !=(CassandraNodeState left, CassandraNodeState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraNodeState"/>. </summary>
        public static implicit operator CassandraNodeState(string value) => new CassandraNodeState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraNodeState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraNodeState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
