// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Cosmos DB Cassandra keyspace resource object. </summary>
    public partial class CassandraKeyspaceResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraKeyspaceResourceInfo"/>. </summary>
        /// <param name="keyspaceName"> Name of the Cosmos DB Cassandra keyspace. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyspaceName"/> is null. </exception>
        public CassandraKeyspaceResourceInfo(string keyspaceName)
        {
            Argument.AssertNotNull(keyspaceName, nameof(keyspaceName));

            KeyspaceName = keyspaceName;
        }

        /// <summary> Initializes a new instance of <see cref="CassandraKeyspaceResourceInfo"/>. </summary>
        /// <param name="keyspaceName"> Name of the Cosmos DB Cassandra keyspace. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraKeyspaceResourceInfo(string keyspaceName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyspaceName = keyspaceName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CassandraKeyspaceResourceInfo"/> for deserialization. </summary>
        internal CassandraKeyspaceResourceInfo()
        {
        }

        /// <summary> Name of the Cosmos DB Cassandra keyspace. </summary>
        [WirePath("id")]
        public string KeyspaceName { get; set; }
    }
}
