// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The CassandraError. </summary>
    public partial class CassandraError
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraError"/>. </summary>
        public CassandraError()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CassandraError"/>. </summary>
        /// <param name="code"> The code of error that occurred. </param>
        /// <param name="message"> The message of the error. </param>
        /// <param name="target"> The target resource of the error. </param>
        /// <param name="additionalErrorInfo"> Additional information about the error. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraError(string code, string message, string target, string additionalErrorInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Message = message;
            Target = target;
            AdditionalErrorInfo = additionalErrorInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The code of error that occurred. </summary>
        [WirePath("code")]
        public string Code { get; set; }
        /// <summary> The message of the error. </summary>
        [WirePath("message")]
        public string Message { get; set; }
        /// <summary> The target resource of the error. </summary>
        [WirePath("target")]
        public string Target { get; set; }
        /// <summary> Additional information about the error. </summary>
        [WirePath("additionalErrorInfo")]
        public string AdditionalErrorInfo { get; set; }
    }
}
