// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class CassandraDataCenterProperties : IUtf8JsonSerializable, IJsonModel<CassandraDataCenterProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CassandraDataCenterProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CassandraDataCenterProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraDataCenterProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CassandraDataCenterProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            if (Optional.IsDefined(DataCenterLocation))
            {
                writer.WritePropertyName("dataCenterLocation"u8);
                writer.WriteStringValue(DataCenterLocation.Value);
            }
            if (Optional.IsDefined(DelegatedSubnetId))
            {
                writer.WritePropertyName("delegatedSubnetId"u8);
                writer.WriteStringValue(DelegatedSubnetId);
            }
            if (Optional.IsDefined(NodeCount))
            {
                writer.WritePropertyName("nodeCount"u8);
                writer.WriteNumberValue(NodeCount.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SeedNodes))
            {
                writer.WritePropertyName("seedNodes"u8);
                writer.WriteStartArray();
                foreach (var item in SeedNodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Base64EncodedCassandraYamlFragment))
            {
                writer.WritePropertyName("base64EncodedCassandraYamlFragment"u8);
                writer.WriteStringValue(Base64EncodedCassandraYamlFragment);
            }
            if (Optional.IsDefined(ManagedDiskCustomerKeyUri))
            {
                writer.WritePropertyName("managedDiskCustomerKeyUri"u8);
                writer.WriteStringValue(ManagedDiskCustomerKeyUri.AbsoluteUri);
            }
            if (Optional.IsDefined(BackupStorageCustomerKeyUri))
            {
                writer.WritePropertyName("backupStorageCustomerKeyUri"u8);
                writer.WriteStringValue(BackupStorageCustomerKeyUri.AbsoluteUri);
            }
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteStringValue(Sku);
            }
            if (Optional.IsDefined(DiskSku))
            {
                writer.WritePropertyName("diskSku"u8);
                writer.WriteStringValue(DiskSku);
            }
            if (Optional.IsDefined(DiskCapacity))
            {
                writer.WritePropertyName("diskCapacity"u8);
                writer.WriteNumberValue(DiskCapacity.Value);
            }
            if (Optional.IsDefined(DoesSupportAvailabilityZone))
            {
                writer.WritePropertyName("availabilityZone"u8);
                writer.WriteBooleanValue(DoesSupportAvailabilityZone.Value);
            }
            if (Optional.IsDefined(AuthenticationMethodLdapProperties))
            {
                writer.WritePropertyName("authenticationMethodLdapProperties"u8);
                writer.WriteObjectValue(AuthenticationMethodLdapProperties, options);
            }
            if (Optional.IsDefined(Deallocated))
            {
                writer.WritePropertyName("deallocated"u8);
                writer.WriteBooleanValue(Deallocated.Value);
            }
            if (Optional.IsDefined(ProvisionError))
            {
                writer.WritePropertyName("provisionError"u8);
                writer.WriteObjectValue(ProvisionError, options);
            }
            if (Optional.IsDefined(PrivateEndpointIPAddress))
            {
                writer.WritePropertyName("privateEndpointIpAddress"u8);
                writer.WriteStringValue(PrivateEndpointIPAddress);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CassandraDataCenterProperties IJsonModel<CassandraDataCenterProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraDataCenterProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CassandraDataCenterProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCassandraDataCenterProperties(document.RootElement, options);
        }

        internal static CassandraDataCenterProperties DeserializeCassandraDataCenterProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            CassandraProvisioningState? provisioningState = default;
            AzureLocation? dataCenterLocation = default;
            ResourceIdentifier delegatedSubnetId = default;
            int? nodeCount = default;
            IReadOnlyList<CassandraDataCenterSeedNode> seedNodes = default;
            string base64EncodedCassandraYamlFragment = default;
            Uri managedDiskCustomerKeyUri = default;
            Uri backupStorageCustomerKeyUri = default;
            string sku = default;
            string diskSku = default;
            int? diskCapacity = default;
            bool? availabilityZone = default;
            AuthenticationMethodLdapProperties authenticationMethodLdapProperties = default;
            bool? deallocated = default;
            CassandraError provisionError = default;
            string privateEndpointIPAddress = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("provisioningState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisioningState = new CassandraProvisioningState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dataCenterLocation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataCenterLocation = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("delegatedSubnetId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    delegatedSubnetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("nodeCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nodeCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("seedNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CassandraDataCenterSeedNode> array = new List<CassandraDataCenterSeedNode>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CassandraDataCenterSeedNode.DeserializeCassandraDataCenterSeedNode(item, options));
                    }
                    seedNodes = array;
                    continue;
                }
                if (property.NameEquals("base64EncodedCassandraYamlFragment"u8))
                {
                    base64EncodedCassandraYamlFragment = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("managedDiskCustomerKeyUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    managedDiskCustomerKeyUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("backupStorageCustomerKeyUri"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupStorageCustomerKeyUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sku"u8))
                {
                    sku = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskSku"u8))
                {
                    diskSku = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskCapacity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskCapacity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("availabilityZone"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    availabilityZone = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("authenticationMethodLdapProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authenticationMethodLdapProperties = AuthenticationMethodLdapProperties.DeserializeAuthenticationMethodLdapProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("deallocated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deallocated = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("provisionError"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    provisionError = CassandraError.DeserializeCassandraError(property.Value, options);
                    continue;
                }
                if (property.NameEquals("privateEndpointIpAddress"u8))
                {
                    privateEndpointIPAddress = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CassandraDataCenterProperties(
                provisioningState,
                dataCenterLocation,
                delegatedSubnetId,
                nodeCount,
                seedNodes ?? new ChangeTrackingList<CassandraDataCenterSeedNode>(),
                base64EncodedCassandraYamlFragment,
                managedDiskCustomerKeyUri,
                backupStorageCustomerKeyUri,
                sku,
                diskSku,
                diskCapacity,
                availabilityZone,
                authenticationMethodLdapProperties,
                deallocated,
                provisionError,
                privateEndpointIPAddress,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("  provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataCenterLocation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataCenterLocation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataCenterLocation))
                {
                    builder.Append("  dataCenterLocation: ");
                    builder.AppendLine($"'{DataCenterLocation.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DelegatedSubnetId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  delegatedSubnetId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DelegatedSubnetId))
                {
                    builder.Append("  delegatedSubnetId: ");
                    builder.AppendLine($"'{DelegatedSubnetId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodeCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodeCount))
                {
                    builder.Append("  nodeCount: ");
                    builder.AppendLine($"{NodeCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SeedNodes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  seedNodes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SeedNodes))
                {
                    if (SeedNodes.Any())
                    {
                        builder.Append("  seedNodes: ");
                        builder.AppendLine("[");
                        foreach (var item in SeedNodes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  seedNodes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Base64EncodedCassandraYamlFragment), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  base64EncodedCassandraYamlFragment: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Base64EncodedCassandraYamlFragment))
                {
                    builder.Append("  base64EncodedCassandraYamlFragment: ");
                    if (Base64EncodedCassandraYamlFragment.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Base64EncodedCassandraYamlFragment}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Base64EncodedCassandraYamlFragment}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ManagedDiskCustomerKeyUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  managedDiskCustomerKeyUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ManagedDiskCustomerKeyUri))
                {
                    builder.Append("  managedDiskCustomerKeyUri: ");
                    builder.AppendLine($"'{ManagedDiskCustomerKeyUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BackupStorageCustomerKeyUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  backupStorageCustomerKeyUri: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BackupStorageCustomerKeyUri))
                {
                    builder.Append("  backupStorageCustomerKeyUri: ");
                    builder.AppendLine($"'{BackupStorageCustomerKeyUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Sku))
                {
                    builder.Append("  sku: ");
                    if (Sku.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Sku}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Sku}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiskSku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diskSku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiskSku))
                {
                    builder.Append("  diskSku: ");
                    if (DiskSku.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DiskSku}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DiskSku}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiskCapacity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diskCapacity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiskCapacity))
                {
                    builder.Append("  diskCapacity: ");
                    builder.AppendLine($"{DiskCapacity.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DoesSupportAvailabilityZone), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  availabilityZone: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DoesSupportAvailabilityZone))
                {
                    builder.Append("  availabilityZone: ");
                    var boolValue = DoesSupportAvailabilityZone.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthenticationMethodLdapProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authenticationMethodLdapProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthenticationMethodLdapProperties))
                {
                    builder.Append("  authenticationMethodLdapProperties: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AuthenticationMethodLdapProperties, options, 2, false, "  authenticationMethodLdapProperties: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Deallocated), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  deallocated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Deallocated))
                {
                    builder.Append("  deallocated: ");
                    var boolValue = Deallocated.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisionError), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  provisionError: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisionError))
                {
                    builder.Append("  provisionError: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ProvisionError, options, 2, false, "  provisionError: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateEndpointIPAddress), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  privateEndpointIpAddress: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PrivateEndpointIPAddress))
                {
                    builder.Append("  privateEndpointIpAddress: ");
                    if (PrivateEndpointIPAddress.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PrivateEndpointIPAddress}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PrivateEndpointIPAddress}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CassandraDataCenterProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraDataCenterProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CassandraDataCenterProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CassandraDataCenterProperties IPersistableModel<CassandraDataCenterProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraDataCenterProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCassandraDataCenterProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CassandraDataCenterProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CassandraDataCenterProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
