// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The kind of connection error that occurred. </summary>
    public readonly partial struct CassandraConnectionState : IEquatable<CassandraConnectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraConnectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraConnectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string OKValue = "OK";
        private const string OperatorToDataCenterNetworkErrorValue = "OperatorToDataCenterNetworkError";
        private const string DatacenterToDatacenterNetworkErrorValue = "DatacenterToDatacenterNetworkError";
        private const string InternalOperatorToDataCenterCertificateErrorValue = "InternalOperatorToDataCenterCertificateError";
        private const string InternalErrorValue = "InternalError";

        /// <summary> Unknown. </summary>
        public static CassandraConnectionState Unknown { get; } = new CassandraConnectionState(UnknownValue);
        /// <summary> OK. </summary>
        public static CassandraConnectionState OK { get; } = new CassandraConnectionState(OKValue);
        /// <summary> OperatorToDataCenterNetworkError. </summary>
        public static CassandraConnectionState OperatorToDataCenterNetworkError { get; } = new CassandraConnectionState(OperatorToDataCenterNetworkErrorValue);
        /// <summary> DatacenterToDatacenterNetworkError. </summary>
        public static CassandraConnectionState DatacenterToDatacenterNetworkError { get; } = new CassandraConnectionState(DatacenterToDatacenterNetworkErrorValue);
        /// <summary> InternalOperatorToDataCenterCertificateError. </summary>
        public static CassandraConnectionState InternalOperatorToDataCenterCertificateError { get; } = new CassandraConnectionState(InternalOperatorToDataCenterCertificateErrorValue);
        /// <summary> InternalError. </summary>
        public static CassandraConnectionState InternalError { get; } = new CassandraConnectionState(InternalErrorValue);
        /// <summary> Determines if two <see cref="CassandraConnectionState"/> values are the same. </summary>
        public static bool operator ==(CassandraConnectionState left, CassandraConnectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraConnectionState"/> values are not the same. </summary>
        public static bool operator !=(CassandraConnectionState left, CassandraConnectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraConnectionState"/>. </summary>
        public static implicit operator CassandraConnectionState(string value) => new CassandraConnectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraConnectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraConnectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
