// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Specification of which command to run where. </summary>
    public partial class CassandraCommandPostBody
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraCommandPostBody"/>. </summary>
        /// <param name="command"> The command which should be run. </param>
        /// <param name="host"> IP address of the cassandra host to run the command on. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="command"/> or <paramref name="host"/> is null. </exception>
        public CassandraCommandPostBody(string command, string host)
        {
            Argument.AssertNotNull(command, nameof(command));
            Argument.AssertNotNull(host, nameof(host));

            Command = command;
            Arguments = new ChangeTrackingDictionary<string, string>();
            Host = host;
        }

        /// <summary> Initializes a new instance of <see cref="CassandraCommandPostBody"/>. </summary>
        /// <param name="command"> The command which should be run. </param>
        /// <param name="arguments"> The arguments for the command to be run. </param>
        /// <param name="host"> IP address of the cassandra host to run the command on. </param>
        /// <param name="cassandraStopStart"> If true, stops cassandra before executing the command and then start it again. </param>
        /// <param name="allowWrite"> If true, allows the command to *write* to the cassandra directory, otherwise read-only. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraCommandPostBody(string command, IDictionary<string, string> arguments, string host, bool? cassandraStopStart, bool? allowWrite, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Command = command;
            Arguments = arguments;
            Host = host;
            CassandraStopStart = cassandraStopStart;
            AllowWrite = allowWrite;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CassandraCommandPostBody"/> for deserialization. </summary>
        internal CassandraCommandPostBody()
        {
        }

        /// <summary> The command which should be run. </summary>
        [WirePath("command")]
        public string Command { get; }
        /// <summary> The arguments for the command to be run. </summary>
        [WirePath("arguments")]
        public IDictionary<string, string> Arguments { get; }
        /// <summary> IP address of the cassandra host to run the command on. </summary>
        [WirePath("host")]
        public string Host { get; }
        /// <summary> If true, stops cassandra before executing the command and then start it again. </summary>
        [WirePath("cassandra-stop-start")]
        public bool? CassandraStopStart { get; set; }
        /// <summary> If true, allows the command to *write* to the cassandra directory, otherwise read-only. </summary>
        [WirePath("readWrite")]
        public bool? AllowWrite { get; set; }
    }
}
