// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Type of the cluster. If set to Production, some operations might not be permitted on cluster. </summary>
    public readonly partial struct CassandraClusterType : IEquatable<CassandraClusterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraClusterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraClusterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProductionValue = "Production";
        private const string NonProductionValue = "NonProduction";

        /// <summary> Production. </summary>
        public static CassandraClusterType Production { get; } = new CassandraClusterType(ProductionValue);
        /// <summary> NonProduction. </summary>
        public static CassandraClusterType NonProduction { get; } = new CassandraClusterType(NonProductionValue);
        /// <summary> Determines if two <see cref="CassandraClusterType"/> values are the same. </summary>
        public static bool operator ==(CassandraClusterType left, CassandraClusterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraClusterType"/> values are not the same. </summary>
        public static bool operator !=(CassandraClusterType left, CassandraClusterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraClusterType"/>. </summary>
        public static implicit operator CassandraClusterType(string value) => new CassandraClusterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraClusterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraClusterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
