// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The CassandraClusterPublicStatusDataCentersItem. </summary>
    public partial class CassandraClusterPublicStatusDataCentersItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraClusterPublicStatusDataCentersItem"/>. </summary>
        internal CassandraClusterPublicStatusDataCentersItem()
        {
            SeedNodes = new ChangeTrackingList<string>();
            Nodes = new ChangeTrackingList<CassandraClusterDataCenterNodeItem>();
        }

        /// <summary> Initializes a new instance of <see cref="CassandraClusterPublicStatusDataCentersItem"/>. </summary>
        /// <param name="name"> The name of this Datacenter. </param>
        /// <param name="seedNodes"> A list of all seed nodes in the cluster, managed and unmanaged. </param>
        /// <param name="nodes"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraClusterPublicStatusDataCentersItem(string name, IReadOnlyList<string> seedNodes, IReadOnlyList<CassandraClusterDataCenterNodeItem> nodes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            SeedNodes = seedNodes;
            Nodes = nodes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of this Datacenter. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> A list of all seed nodes in the cluster, managed and unmanaged. </summary>
        [WirePath("seedNodes")]
        public IReadOnlyList<string> SeedNodes { get; }
        /// <summary> Gets the nodes. </summary>
        [WirePath("nodes")]
        public IReadOnlyList<CassandraClusterDataCenterNodeItem> Nodes { get; }
    }
}
