// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The CassandraClusterDataCenterNodeItem. </summary>
    public partial class CassandraClusterDataCenterNodeItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CassandraClusterDataCenterNodeItem"/>. </summary>
        internal CassandraClusterDataCenterNodeItem()
        {
            Tokens = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CassandraClusterDataCenterNodeItem"/>. </summary>
        /// <param name="address"> The node's IP address. </param>
        /// <param name="state"> The state of the node in Cassandra ring. </param>
        /// <param name="status"></param>
        /// <param name="cassandraProcessStatus"> Cassandra service status on this node. </param>
        /// <param name="load"> The amount of file system data in the data directory (e.g., 47.66 kB), excluding all content in the snapshots subdirectories. Because all SSTable data files are included, any data that is not cleaned up (such as TTL-expired cells or tombstones) is counted. </param>
        /// <param name="tokens"> List of tokens this node covers. </param>
        /// <param name="size"></param>
        /// <param name="hostId"> The network ID of the node. </param>
        /// <param name="rack"> The rack this node is part of. </param>
        /// <param name="timestamp"> The timestamp when these statistics were captured. </param>
        /// <param name="diskUsedKB"> The amount of disk used, in kB, of the directory /var/lib/cassandra. </param>
        /// <param name="diskFreeKB"> The amount of disk free, in kB, of the directory /var/lib/cassandra. </param>
        /// <param name="memoryUsedKB"> Used memory (calculated as total - free - buffers - cache), in kB. </param>
        /// <param name="memoryBuffersAndCachedKB"> Memory used by kernel buffers (Buffers in /proc/meminfo) and page cache and slabs (Cached and SReclaimable in /proc/meminfo), in kB. </param>
        /// <param name="memoryFreeKB"> Unused memory (MemFree and SwapFree in /proc/meminfo), in kB. </param>
        /// <param name="memoryTotalKB"> Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB. </param>
        /// <param name="cpuUsage"> A float representing the current system-wide CPU utilization as a percentage. </param>
        /// <param name="isLatestModel"> If node has been updated to latest model. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CassandraClusterDataCenterNodeItem(string address, CassandraNodeState? state, string status, string cassandraProcessStatus, string load, IReadOnlyList<string> tokens, int? size, Guid? hostId, string rack, string timestamp, long? diskUsedKB, long? diskFreeKB, long? memoryUsedKB, long? memoryBuffersAndCachedKB, long? memoryFreeKB, long? memoryTotalKB, double? cpuUsage, bool? isLatestModel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Address = address;
            State = state;
            Status = status;
            CassandraProcessStatus = cassandraProcessStatus;
            Load = load;
            Tokens = tokens;
            Size = size;
            HostId = hostId;
            Rack = rack;
            Timestamp = timestamp;
            DiskUsedKB = diskUsedKB;
            DiskFreeKB = diskFreeKB;
            MemoryUsedKB = memoryUsedKB;
            MemoryBuffersAndCachedKB = memoryBuffersAndCachedKB;
            MemoryFreeKB = memoryFreeKB;
            MemoryTotalKB = memoryTotalKB;
            CpuUsage = cpuUsage;
            IsLatestModel = isLatestModel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The node's IP address. </summary>
        [WirePath("address")]
        public string Address { get; }
        /// <summary> The state of the node in Cassandra ring. </summary>
        [WirePath("state")]
        public CassandraNodeState? State { get; }
        /// <summary> Gets the status. </summary>
        [WirePath("status")]
        public string Status { get; }
        /// <summary> Cassandra service status on this node. </summary>
        [WirePath("cassandraProcessStatus")]
        public string CassandraProcessStatus { get; }
        /// <summary> The amount of file system data in the data directory (e.g., 47.66 kB), excluding all content in the snapshots subdirectories. Because all SSTable data files are included, any data that is not cleaned up (such as TTL-expired cells or tombstones) is counted. </summary>
        [WirePath("load")]
        public string Load { get; }
        /// <summary> List of tokens this node covers. </summary>
        [WirePath("tokens")]
        public IReadOnlyList<string> Tokens { get; }
        /// <summary> Gets the size. </summary>
        [WirePath("size")]
        public int? Size { get; }
        /// <summary> The network ID of the node. </summary>
        [WirePath("hostID")]
        public Guid? HostId { get; }
        /// <summary> The rack this node is part of. </summary>
        [WirePath("rack")]
        public string Rack { get; }
        /// <summary> The timestamp when these statistics were captured. </summary>
        [WirePath("timestamp")]
        public string Timestamp { get; }
        /// <summary> The amount of disk used, in kB, of the directory /var/lib/cassandra. </summary>
        [WirePath("diskUsedKB")]
        public long? DiskUsedKB { get; }
        /// <summary> The amount of disk free, in kB, of the directory /var/lib/cassandra. </summary>
        [WirePath("diskFreeKB")]
        public long? DiskFreeKB { get; }
        /// <summary> Used memory (calculated as total - free - buffers - cache), in kB. </summary>
        [WirePath("memoryUsedKB")]
        public long? MemoryUsedKB { get; }
        /// <summary> Memory used by kernel buffers (Buffers in /proc/meminfo) and page cache and slabs (Cached and SReclaimable in /proc/meminfo), in kB. </summary>
        [WirePath("memoryBuffersAndCachedKB")]
        public long? MemoryBuffersAndCachedKB { get; }
        /// <summary> Unused memory (MemFree and SwapFree in /proc/meminfo), in kB. </summary>
        [WirePath("memoryFreeKB")]
        public long? MemoryFreeKB { get; }
        /// <summary> Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB. </summary>
        [WirePath("memoryTotalKB")]
        public long? MemoryTotalKB { get; }
        /// <summary> A float representing the current system-wide CPU utilization as a percentage. </summary>
        [WirePath("cpuUsage")]
        public double? CpuUsage { get; }
        /// <summary> If node has been updated to latest model. </summary>
        [WirePath("isLatestModel")]
        public bool? IsLatestModel { get; }
    }
}
