// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.CosmosDB.Models
{
    public partial class CassandraClusterDataCenterNodeItem : IUtf8JsonSerializable, IJsonModel<CassandraClusterDataCenterNodeItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CassandraClusterDataCenterNodeItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CassandraClusterDataCenterNodeItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraClusterDataCenterNodeItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CassandraClusterDataCenterNodeItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Address))
            {
                writer.WritePropertyName("address"u8);
                writer.WriteStringValue(Address);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (Optional.IsDefined(CassandraProcessStatus))
            {
                writer.WritePropertyName("cassandraProcessStatus"u8);
                writer.WriteStringValue(CassandraProcessStatus);
            }
            if (Optional.IsDefined(Load))
            {
                writer.WritePropertyName("load"u8);
                writer.WriteStringValue(Load);
            }
            if (Optional.IsCollectionDefined(Tokens))
            {
                writer.WritePropertyName("tokens"u8);
                writer.WriteStartArray();
                foreach (var item in Tokens)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Size))
            {
                writer.WritePropertyName("size"u8);
                writer.WriteNumberValue(Size.Value);
            }
            if (Optional.IsDefined(HostId))
            {
                writer.WritePropertyName("hostID"u8);
                writer.WriteStringValue(HostId.Value);
            }
            if (Optional.IsDefined(Rack))
            {
                writer.WritePropertyName("rack"u8);
                writer.WriteStringValue(Rack);
            }
            if (Optional.IsDefined(Timestamp))
            {
                writer.WritePropertyName("timestamp"u8);
                writer.WriteStringValue(Timestamp);
            }
            if (Optional.IsDefined(DiskUsedKB))
            {
                writer.WritePropertyName("diskUsedKB"u8);
                writer.WriteNumberValue(DiskUsedKB.Value);
            }
            if (Optional.IsDefined(DiskFreeKB))
            {
                writer.WritePropertyName("diskFreeKB"u8);
                writer.WriteNumberValue(DiskFreeKB.Value);
            }
            if (Optional.IsDefined(MemoryUsedKB))
            {
                writer.WritePropertyName("memoryUsedKB"u8);
                writer.WriteNumberValue(MemoryUsedKB.Value);
            }
            if (Optional.IsDefined(MemoryBuffersAndCachedKB))
            {
                writer.WritePropertyName("memoryBuffersAndCachedKB"u8);
                writer.WriteNumberValue(MemoryBuffersAndCachedKB.Value);
            }
            if (Optional.IsDefined(MemoryFreeKB))
            {
                writer.WritePropertyName("memoryFreeKB"u8);
                writer.WriteNumberValue(MemoryFreeKB.Value);
            }
            if (Optional.IsDefined(MemoryTotalKB))
            {
                writer.WritePropertyName("memoryTotalKB"u8);
                writer.WriteNumberValue(MemoryTotalKB.Value);
            }
            if (Optional.IsDefined(CpuUsage))
            {
                writer.WritePropertyName("cpuUsage"u8);
                writer.WriteNumberValue(CpuUsage.Value);
            }
            if (Optional.IsDefined(IsLatestModel))
            {
                writer.WritePropertyName("isLatestModel"u8);
                writer.WriteBooleanValue(IsLatestModel.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CassandraClusterDataCenterNodeItem IJsonModel<CassandraClusterDataCenterNodeItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraClusterDataCenterNodeItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CassandraClusterDataCenterNodeItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCassandraClusterDataCenterNodeItem(document.RootElement, options);
        }

        internal static CassandraClusterDataCenterNodeItem DeserializeCassandraClusterDataCenterNodeItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string address = default;
            CassandraNodeState? state = default;
            string status = default;
            string cassandraProcessStatus = default;
            string load = default;
            IReadOnlyList<string> tokens = default;
            int? size = default;
            Guid? hostId = default;
            string rack = default;
            string timestamp = default;
            long? diskUsedKB = default;
            long? diskFreeKB = default;
            long? memoryUsedKB = default;
            long? memoryBuffersAndCachedKB = default;
            long? memoryFreeKB = default;
            long? memoryTotalKB = default;
            double? cpuUsage = default;
            bool? isLatestModel = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("address"u8))
                {
                    address = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new CassandraNodeState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cassandraProcessStatus"u8))
                {
                    cassandraProcessStatus = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("load"u8))
                {
                    load = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tokens"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    tokens = array;
                    continue;
                }
                if (property.NameEquals("size"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    size = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("hostID"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hostId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("rack"u8))
                {
                    rack = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timestamp"u8))
                {
                    timestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("diskUsedKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskUsedKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("diskFreeKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diskFreeKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryUsedKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryUsedKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryBuffersAndCachedKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryBuffersAndCachedKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryFreeKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryFreeKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("memoryTotalKB"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    memoryTotalKB = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("cpuUsage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cpuUsage = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("isLatestModel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isLatestModel = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CassandraClusterDataCenterNodeItem(
                address,
                state,
                status,
                cassandraProcessStatus,
                load,
                tokens ?? new ChangeTrackingList<string>(),
                size,
                hostId,
                rack,
                timestamp,
                diskUsedKB,
                diskFreeKB,
                memoryUsedKB,
                memoryBuffersAndCachedKB,
                memoryFreeKB,
                memoryTotalKB,
                cpuUsage,
                isLatestModel,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Address), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  address: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Address))
                {
                    builder.Append("  address: ");
                    if (Address.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Address}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Address}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("  state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    if (Status.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Status}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Status}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CassandraProcessStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cassandraProcessStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CassandraProcessStatus))
                {
                    builder.Append("  cassandraProcessStatus: ");
                    if (CassandraProcessStatus.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CassandraProcessStatus}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CassandraProcessStatus}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Load), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  load: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Load))
                {
                    builder.Append("  load: ");
                    if (Load.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Load}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Load}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tokens), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokens: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tokens))
                {
                    if (Tokens.Any())
                    {
                        builder.Append("  tokens: ");
                        builder.AppendLine("[");
                        foreach (var item in Tokens)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Size), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  size: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Size))
                {
                    builder.Append("  size: ");
                    builder.AppendLine($"{Size.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hostID: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HostId))
                {
                    builder.Append("  hostID: ");
                    builder.AppendLine($"'{HostId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Rack), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rack: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Rack))
                {
                    builder.Append("  rack: ");
                    if (Rack.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Rack}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Rack}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Timestamp), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  timestamp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Timestamp))
                {
                    builder.Append("  timestamp: ");
                    if (Timestamp.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Timestamp}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Timestamp}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiskUsedKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diskUsedKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiskUsedKB))
                {
                    builder.Append("  diskUsedKB: ");
                    builder.AppendLine($"'{DiskUsedKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiskFreeKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diskFreeKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiskFreeKB))
                {
                    builder.Append("  diskFreeKB: ");
                    builder.AppendLine($"'{DiskFreeKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MemoryUsedKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  memoryUsedKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MemoryUsedKB))
                {
                    builder.Append("  memoryUsedKB: ");
                    builder.AppendLine($"'{MemoryUsedKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MemoryBuffersAndCachedKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  memoryBuffersAndCachedKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MemoryBuffersAndCachedKB))
                {
                    builder.Append("  memoryBuffersAndCachedKB: ");
                    builder.AppendLine($"'{MemoryBuffersAndCachedKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MemoryFreeKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  memoryFreeKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MemoryFreeKB))
                {
                    builder.Append("  memoryFreeKB: ");
                    builder.AppendLine($"'{MemoryFreeKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MemoryTotalKB), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  memoryTotalKB: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MemoryTotalKB))
                {
                    builder.Append("  memoryTotalKB: ");
                    builder.AppendLine($"'{MemoryTotalKB.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CpuUsage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  cpuUsage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CpuUsage))
                {
                    builder.Append("  cpuUsage: ");
                    builder.AppendLine($"'{CpuUsage.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsLatestModel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isLatestModel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsLatestModel))
                {
                    builder.Append("  isLatestModel: ");
                    var boolValue = IsLatestModel.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CassandraClusterDataCenterNodeItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraClusterDataCenterNodeItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CassandraClusterDataCenterNodeItem)} does not support writing '{options.Format}' format.");
            }
        }

        CassandraClusterDataCenterNodeItem IPersistableModel<CassandraClusterDataCenterNodeItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CassandraClusterDataCenterNodeItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCassandraClusterDataCenterNodeItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CassandraClusterDataCenterNodeItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CassandraClusterDataCenterNodeItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
