// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Status of the command. </summary>
    public readonly partial struct CassandraClusterCommandStatus : IEquatable<CassandraClusterCommandStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CassandraClusterCommandStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CassandraClusterCommandStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DoneValue = "Done";
        private const string RunningValue = "Running";
        private const string EnqueueValue = "Enqueue";
        private const string ProcessingValue = "Processing";
        private const string FinishedValue = "Finished";
        private const string FailedValue = "Failed";

        /// <summary> Done. </summary>
        public static CassandraClusterCommandStatus Done { get; } = new CassandraClusterCommandStatus(DoneValue);
        /// <summary> Running. </summary>
        public static CassandraClusterCommandStatus Running { get; } = new CassandraClusterCommandStatus(RunningValue);
        /// <summary> Enqueue. </summary>
        public static CassandraClusterCommandStatus Enqueue { get; } = new CassandraClusterCommandStatus(EnqueueValue);
        /// <summary> Processing. </summary>
        public static CassandraClusterCommandStatus Processing { get; } = new CassandraClusterCommandStatus(ProcessingValue);
        /// <summary> Finished. </summary>
        public static CassandraClusterCommandStatus Finished { get; } = new CassandraClusterCommandStatus(FinishedValue);
        /// <summary> Failed. </summary>
        public static CassandraClusterCommandStatus Failed { get; } = new CassandraClusterCommandStatus(FailedValue);
        /// <summary> Determines if two <see cref="CassandraClusterCommandStatus"/> values are the same. </summary>
        public static bool operator ==(CassandraClusterCommandStatus left, CassandraClusterCommandStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CassandraClusterCommandStatus"/> values are not the same. </summary>
        public static bool operator !=(CassandraClusterCommandStatus left, CassandraClusterCommandStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CassandraClusterCommandStatus"/>. </summary>
        public static implicit operator CassandraClusterCommandStatus(string value) => new CassandraClusterCommandStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CassandraClusterCommandStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CassandraClusterCommandStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
