// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> The transition status of capacity mode. </summary>
    public readonly partial struct CapacityModeTransitionStatus : IEquatable<CapacityModeTransitionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CapacityModeTransitionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CapacityModeTransitionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string InitializedValue = "Initialized";
        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";
        private const string FailedValue = "Failed";

        /// <summary> Invalid. </summary>
        public static CapacityModeTransitionStatus Invalid { get; } = new CapacityModeTransitionStatus(InvalidValue);
        /// <summary> Initialized. </summary>
        public static CapacityModeTransitionStatus Initialized { get; } = new CapacityModeTransitionStatus(InitializedValue);
        /// <summary> InProgress. </summary>
        public static CapacityModeTransitionStatus InProgress { get; } = new CapacityModeTransitionStatus(InProgressValue);
        /// <summary> Completed. </summary>
        public static CapacityModeTransitionStatus Completed { get; } = new CapacityModeTransitionStatus(CompletedValue);
        /// <summary> Failed. </summary>
        public static CapacityModeTransitionStatus Failed { get; } = new CapacityModeTransitionStatus(FailedValue);
        /// <summary> Determines if two <see cref="CapacityModeTransitionStatus"/> values are the same. </summary>
        public static bool operator ==(CapacityModeTransitionStatus left, CapacityModeTransitionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CapacityModeTransitionStatus"/> values are not the same. </summary>
        public static bool operator !=(CapacityModeTransitionStatus left, CapacityModeTransitionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CapacityModeTransitionStatus"/>. </summary>
        public static implicit operator CapacityModeTransitionStatus(string value) => new CapacityModeTransitionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CapacityModeTransitionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CapacityModeTransitionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
