// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Indicates the capacity mode of the account. </summary>
    public readonly partial struct CapacityMode : IEquatable<CapacityMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CapacityMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CapacityMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ProvisionedValue = "Provisioned";
        private const string ServerlessValue = "Serverless";

        /// <summary> None. </summary>
        public static CapacityMode None { get; } = new CapacityMode(NoneValue);
        /// <summary> Provisioned. </summary>
        public static CapacityMode Provisioned { get; } = new CapacityMode(ProvisionedValue);
        /// <summary> Serverless. </summary>
        public static CapacityMode Serverless { get; } = new CapacityMode(ServerlessValue);
        /// <summary> Determines if two <see cref="CapacityMode"/> values are the same. </summary>
        public static bool operator ==(CapacityMode left, CapacityMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CapacityMode"/> values are not the same. </summary>
        public static bool operator !=(CapacityMode left, CapacityMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CapacityMode"/>. </summary>
        public static implicit operator CapacityMode(string value) => new CapacityMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CapacityMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CapacityMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
