// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary>
    /// A base CosmosDB data source/sink
    /// Please note <see cref="BaseCosmosDataTransferDataSourceSink"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="CosmosCassandraDataTransferDataSourceSink"/>, <see cref="CosmosMongoDataTransferDataSourceSink"/> and <see cref="CosmosSqlDataTransferDataSourceSink"/>.
    /// </summary>
    public partial class BaseCosmosDataTransferDataSourceSink : DataTransferDataSourceSink
    {
        /// <summary> Initializes a new instance of <see cref="BaseCosmosDataTransferDataSourceSink"/>. </summary>
        public BaseCosmosDataTransferDataSourceSink()
        {
            Component = new DataTransferComponent("BaseCosmosDataTransferDataSourceSink");
        }

        /// <summary> Initializes a new instance of <see cref="BaseCosmosDataTransferDataSourceSink"/>. </summary>
        /// <param name="component"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="remoteAccountName"></param>
        internal BaseCosmosDataTransferDataSourceSink(DataTransferComponent component, IDictionary<string, BinaryData> serializedAdditionalRawData, string remoteAccountName) : base(component, serializedAdditionalRawData)
        {
            RemoteAccountName = remoteAccountName;
            Component = component;
        }

        /// <summary> Gets or sets the remote account name. </summary>
        [WirePath("remoteAccountName")]
        public string RemoteAccountName { get; set; }
    }
}
