// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.CosmosDB.Models
{
    /// <summary> Describes the mode of backups. </summary>
    public readonly partial struct BackupPolicyType : IEquatable<BackupPolicyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupPolicyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupPolicyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PeriodicValue = "Periodic";
        private const string ContinuousValue = "Continuous";

        /// <summary> Periodic. </summary>
        public static BackupPolicyType Periodic { get; } = new BackupPolicyType(PeriodicValue);
        /// <summary> Continuous. </summary>
        public static BackupPolicyType Continuous { get; } = new BackupPolicyType(ContinuousValue);
        /// <summary> Determines if two <see cref="BackupPolicyType"/> values are the same. </summary>
        public static bool operator ==(BackupPolicyType left, BackupPolicyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupPolicyType"/> values are not the same. </summary>
        public static bool operator !=(BackupPolicyType left, BackupPolicyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupPolicyType"/>. </summary>
        public static implicit operator BackupPolicyType(string value) => new BackupPolicyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupPolicyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupPolicyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
